/*!
 * Cropper v0.7.8
 * https://github.com/fengyuanchen/cropper
 *
 * Copyright 2014-2015 Fengyuan Chen
 * Released under the MIT license
 */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery"],a)}else{if(typeof exports==="object"){a(require("jquery"))}else{a(jQuery)}}})(function(B){var J=B(window),r=B(document),n=window.location,v=true,L=false,x=null,N=NaN,k=Infinity,u="undefined",j="directive",e=".cropper",R=/^(e|n|w|s|ne|nw|sw|se|all|crop|move|zoom)$/,m=/^(x|y|width|height)$/,C=/^(naturalWidth|naturalHeight|width|height|aspectRatio|ratio|rotate)$/,O="cropper-modal",F="cropper-hidden",H="cropper-invisible",c="cropper-move",G="cropper-crop",E="cropper-disabled",l="mousedown touchstart",p="mousemove touchmove",K="mouseup mouseleave touchend touchleave touchcancel",d="wheel mousewheel DOMMouseScroll",a="resize"+e,f="dblclick",A="build"+e,o="built"+e,z="dragstart"+e,y="dragmove"+e,h="dragend"+e,Q=function(S){return typeof S==="number"},s=function(T,U){var S=[];if(Q(U)){S.push(U)}return S.slice.apply(T,S)},I=function(U,T){var S=s(arguments,2);return function(){return U.apply(T,S.concat(s(arguments)))}},g=function(S){var T="timestamp="+(new Date()).getTime();return(S+(S.indexOf("?")===-1?"?":"&")+T)},t=function(T,S){this.element=T;this.$element=B(T);this.defaults=B.extend({},t.DEFAULTS,B.isPlainObject(S)?S:{});this.$original=x;this.ready=L;this.built=L;this.cropped=L;this.rotated=L;this.disabled=L;this.replaced=L;this.init()},D=Math.sqrt,P=Math.min,q=Math.max,w=Math.abs,i=Math.sin,b=Math.cos,M=parseFloat;t.prototype={constructor:t,support:{canvas:B.isFunction(B("<canvas>")[0].getContext)},init:function(){var S=this.defaults;B.each(S,function(T,U){switch(T){case"aspectRatio":S[T]=w(M(U))||N;break;case"autoCropArea":S[T]=w(M(U))||0.8;break;case"minWidth":case"minHeight":S[T]=w(M(U))||0;break;case"maxWidth":case"maxHeight":S[T]=w(M(U))||k;break}});this.image={rotate:0};this.load()},load:function(){var Y=this,X=this.$element,U=this.element,W=this.image,S="",V,T;if(X.is("img")){T=X.prop("src")}else{if(X.is("canvas")&&this.support.canvas){T=U.toDataURL()}}if(!T){return}if(this.replaced){W.rotate=0}if(this.defaults.checkImageOrigin&&this.isCrossOriginURL(T)){S=" crossOrigin";T=g(T)}this.$clone=(V=B("<img"+S+' src="'+T+'">'));V.one("load",function(){W.naturalWidth=this.naturalWidth||V.width();W.naturalHeight=this.naturalHeight||V.height();W.aspectRatio=W.naturalWidth/W.naturalHeight;Y.url=T;Y.ready=v;Y.build()});V.addClass(H).prependTo("body")},isCrossOriginURL:function(S){var T=S.match(/^(https?:)\/\/([^\:\/\?#]+):?(\d*)/i);if((T&&(T[1]!==n.protocol||T[2]!==n.hostname||T[3]!==n.port))){return v}return L},build:function(){var V=this.$element,U=this.defaults,T,S;if(!this.ready){return}if(this.built){this.unbuild()}V.one(A,U.build);T=B.Event(A);V.trigger(T);if(T.isDefaultPrevented()){return}this.$cropper=(S=B(t.TEMPLATE));V.addClass(F);this.$clone.removeClass(H).prependTo(S);if(!this.rotated){this.$original=this.$clone.clone();this.$original.addClass(F).prependTo(this.$cropper);this.originalImage=B.extend({},this.image)}this.$container=V.parent();this.$container.append(S);this.$canvas=S.find(".cropper-canvas");this.$dragger=S.find(".cropper-dragger");this.$viewer=S.find(".cropper-viewer");U.autoCrop?(this.cropped=v):this.$dragger.addClass(F);U.modal&&this.$canvas.addClass(O);!U.dashed&&this.$dragger.find(".cropper-dashed").addClass(F);!U.movable&&this.$dragger.find(".cropper-face").data(j,"move");!U.resizable&&this.$dragger.find(".cropper-line, .cropper-point").addClass(F);this.addListeners();this.initPreview();this.built=v;U.dragCrop&&this.setDragMode("crop");this.update();this.replaced=L;V.one(o,U.built);V.trigger(o)},unbuild:function(){if(!this.built){return}this.built=L;this.removeListeners();this.$preview.empty();this.$preview=x;this.$dragger=x;this.$canvas=x;this.$container=x;this.$cropper.remove();this.$cropper=x},update:function(S){this.initContainer();this.initCropper();this.initImage();this.initDragger();if(S){this.setData(S,v);this.setDragMode("crop")}else{this.setData(this.defaults.data)}},resize:function(){clearTimeout(this.resizing);this.resizing=setTimeout(B.proxy(this.update,this,this.getData()),200)},preview:function(){var X=this.image,W=this.dragger,T=X.width,S=X.height,V=W.left-X.left,U=W.top-X.top;this.$viewer.find("img").css({width:T,height:S,marginLeft:-V,marginTop:-U});this.$preview.each(function(){var Z=B(this),Y=Z.width()/W.width;Z.find("img").css({width:T*Y,height:S*Y,marginLeft:-V*Y,marginTop:-U*Y})})},addListeners:function(){var S=this.defaults;this.$element.on(z,S.dragstart).on(y,S.dragmove).on(h,S.dragend);this.$cropper.on(l,B.proxy(this.dragstart,this)).on(f,B.proxy(this.dblclick,this));if(S.zoomable){this.$cropper.on(d,B.proxy(this.wheel,this))}if(S.multiple){this.$cropper.on(p,B.proxy(this.dragmove,this)).on(K,B.proxy(this.dragend,this))}else{r.on(p,(this._dragmove=I(this.dragmove,this))).on(K,(this._dragend=I(this.dragend,this)))}J.on(a,(this._resize=I(this.resize,this)))},removeListeners:function(){var S=this.defaults;this.$element.off(z,S.dragstart).off(y,S.dragmove).off(h,S.dragend);this.$cropper.off(l,this.dragstart).off(f,this.dblclick);if(S.zoomable){this.$cropper.off(d,this.wheel)}if(S.multiple){this.$cropper.off(p,this.dragmove).off(K,this.dragend)}else{r.off(p,this._dragmove).off(K,this._dragend)}J.off(a,this._resize)},initPreview:function(){var S='<img src="'+this.url+'">';this.$preview=B(this.defaults.preview);this.$viewer.html(S);this.$preview.html(S).find("img").css("cssText","min-width:0!important;min-height:0!important;max-width:none!important;max-height:none!important;")},initContainer:function(){var T=this.$container,S=this.defaults;this.container={width:q(T.width(),S.minContainerWidth),height:q(T.height(),S.minContainerHeight)}},initCropper:function(){var S=this.container,U=this.image,T;if(((U.naturalWidth*S.height/U.naturalHeight)-S.width)>=0){T={width:S.width,height:S.width/U.aspectRatio,left:0};T.top=(S.height-T.height)/2}else{T={width:S.height*U.aspectRatio,height:S.height,top:0};T.left=(S.width-T.width)/2}this.$cropper.css({width:T.width,height:T.height,left:T.left,top:T.top});this.cropper=T},initImage:function(){var U=this.image,T=this.cropper,S={_width:T.width,_height:T.height,width:T.width,height:T.height,left:0,top:0,ratio:T.width/U.naturalWidth};this.defaultImage=B.extend({},U,S);if(U._width!==T.width||U._height!==T.height){B.extend(U,S)}else{U=B.extend({},S,U);if(this.replaced){U.ratio=S.ratio}}this.image=U;this.renderImage()},renderImage:function(T){var S=this.image;if(T==="zoom"){S.left-=(S.width-S.oldWidth)/2;S.top-=(S.height-S.oldHeight)/2}S.left=P(q(S.left,S._width-S.width),0);S.top=P(q(S.top,S._height-S.height),0);this.$clone.css({width:S.width,height:S.height,marginLeft:S.left,marginTop:S.top});if(T){this.defaults.done(this.getData());this.preview()}},initDragger:function(){var X=this.defaults,U=this.cropper,V=X.aspectRatio||this.image.aspectRatio,T=this.image.ratio,S,W;if(((U.height*V)-U.width)>=0){W={height:U.width/V,width:U.width,left:0,top:(U.height-(U.width/V))/2,maxWidth:U.width,maxHeight:U.width/V}}else{W={height:U.height,width:U.height*V,left:(U.width-(U.height*V))/2,top:0,maxWidth:U.height*V,maxHeight:U.height}}W.minWidth=0;W.minHeight=0;if(X.aspectRatio){if(isFinite(X.maxWidth)){W.maxWidth=P(W.maxWidth,X.maxWidth*T);W.maxHeight=W.maxWidth/V}else{if(isFinite(X.maxHeight)){W.maxHeight=P(W.maxHeight,X.maxHeight*T);W.maxWidth=W.maxHeight*V}}if(X.minWidth>0){W.minWidth=q(0,X.minWidth*T);W.minHeight=W.minWidth/V}else{if(X.minHeight>0){W.minHeight=q(0,X.minHeight*T);W.minWidth=W.minHeight*V}}}else{W.maxWidth=P(W.maxWidth,X.maxWidth*T);W.maxHeight=P(W.maxHeight,X.maxHeight*T);W.minWidth=q(0,X.minWidth*T);W.minHeight=q(0,X.minHeight*T)}W.minWidth=P(W.maxWidth,W.minWidth);W.minHeight=P(W.maxHeight,W.minHeight);S=B.extend({},W);S.width=q(W.minWidth,W.width*X.autoCropArea);S.height=q(W.minHeight,W.height*X.autoCropArea);S.left=(U.width-S.width)/2;S.top=(U.height-S.height)/2;S.oldLeft=W.oldLeft=W.left;S.oldTop=W.oldTop=W.top;this.autoCropDragger=S;this.defaultDragger=B.extend({},W);this.dragger=W},renderDragger:function(){var T=this.dragger,S=this.cropper;if(T.width>T.maxWidth){T.width=T.maxWidth;T.left=T.oldLeft}else{if(T.width<T.minWidth){T.width=T.minWidth;T.left=T.oldLeft}}if(T.height>T.maxHeight){T.height=T.maxHeight;T.top=T.oldTop}else{if(T.height<T.minHeight){T.height=T.minHeight;T.top=T.oldTop}}T.left=P(q(T.left,0),S.width-T.width);T.top=P(q(T.top,0),S.height-T.height);T.oldLeft=T.left;T.oldTop=T.top;this.dragger=T;if(!this.disabled){this.defaults.done(this.getData())}this.$dragger.css({width:T.width,height:T.height,left:T.left,top:T.top});this.preview()},reset:function(S){if(!this.cropped||this.disabled){return}if(S){this.defaults.data={}}this.image=B.extend({},this.defaultImage);this.renderImage();this.dragger=B.extend({},this.defaultDragger);this.setData(this.defaults.data)},clear:function(){if(!this.cropped||this.disabled){return}this.cropped=L;this.setData({x:0,y:0,width:0,height:0});this.$canvas.removeClass(O);this.$dragger.addClass(F)},destroy:function(){var S=this.$element;if(!this.ready){this.$clone.off("load").remove()}this.unbuild();S.removeClass(F).removeData("cropper");if(this.rotated){S.attr("src",this.$original.attr("src"))}},replace:function(T,S){var X=this,W=this.$element,V=this.element,U;if(!this.disabled&&T&&T!==this.url&&T!==W.attr("src")){if(!S){this.rotated=L;this.replaced=v}if(W.is("img")){W.attr("src",T);this.load()}else{if(W.is("canvas")&&this.support.canvas){U=V.getContext("2d");B('<img src="'+T+'">').one("load",function(){V.width=this.width;V.height=this.height;U.clearRect(0,0,V.width,V.height);U.drawImage(this,0,0);X.load()})}}}},setData:function(V,T){var S=this.cropper,X=this.dragger,W=this.image,U=this.defaults.aspectRatio;if(!this.built||this.disabled||typeof V===u){return}if(V===x||B.isEmptyObject(V)){X=B.extend({},this.autoCropDragger)}if(B.isPlainObject(V)&&!B.isEmptyObject(V)){if(!T){this.defaults.data=V}V=this.transformData(V);if(Q(V.x)&&V.x<=S.width-W.left){X.left=V.x+W.left}if(Q(V.y)&&V.y<=S.height-W.top){X.top=V.y+W.top}if(U){if(Q(V.width)&&V.width<=X.maxWidth&&V.width>=X.minWidth){X.width=V.width;X.height=X.width/U}else{if(Q(V.height)&&V.height<=X.maxHeight&&V.height>=X.minHeight){X.height=V.height;X.width=X.height*U}}}else{if(Q(V.width)&&V.width<=X.maxWidth&&V.width>=X.minWidth){X.width=V.width}if(Q(V.height)&&V.height<=X.maxHeight&&V.height>=X.minHeight){X.height=V.height}}}this.dragger=X;this.renderDragger()},getData:function(S){var V=this.dragger,U=this.image,T={};if(this.built){T={x:V.left-U.left,y:V.top-U.top,width:V.width,height:V.height};T=this.transformData(T,v,S)}return T},transformData:function(V,W,T){var U=this.image.ratio,S={};B.each(V,function(X,Y){Y=M(Y);if(m.test(X)&&!isNaN(Y)){S[X]=W?(T?Math.round(Y/U):Y/U):Y*U}});return S},setAspectRatio:function(S){var T=S==="auto";if(this.disabled){return}S=M(S);if(T||(!isNaN(S)&&S>0)){this.defaults.aspectRatio=T?N:S;if(this.built){this.initDragger();this.renderDragger();this.setData(this.defaults.data)}}},getImageData:function(){var S={};if(this.ready){B.each(this.image,function(T,U){if(C.test(T)){S[T]=U}})}return S},getDataURL:function(T,V,Y){var S=B("<canvas>")[0],W=this.getData(),X="",U;if(!B.isPlainObject(T)){Y=V;V=T;T={}}T=B.extend({width:W.width,height:W.height},T);if(this.cropped&&this.support.canvas){S.width=T.width;S.height=T.height;U=S.getContext("2d");if(V==="image/jpeg"){U.fillStyle="#fff";U.fillRect(0,0,T.width,T.height)}U.drawImage(this.$clone[0],W.x,W.y,W.width,W.height,0,0,T.width,T.height);X=S.toDataURL(V,Y)}return X},setDragMode:function(W){var T=this.$canvas,V=this.defaults,S=L,U=L;if(!this.built||this.disabled){return}switch(W){case"crop":if(V.dragCrop){S=v;T.data(j,W)}break;case"move":U=v;T.data(j,W);break;default:T.removeData(j)}T.toggleClass(G,S).toggleClass(c,U)},enable:function(){if(this.built){this.disabled=L;this.$cropper.removeClass(E)}},disable:function(){if(this.built){this.disabled=v;this.$cropper.addClass(E)}},rotate:function(T){var S=this.image;T=M(T)||0;if(!this.built||T===0||this.disabled||!this.defaults.rotatable||!this.support.canvas){return}this.rotated=v;T=(S.rotate=(S.rotate+T)%360);this.replace(this.getRotatedDataURL(T),true)},getRotatedDataURL:function(Y){var W=B("<canvas>")[0],U=W.getContext("2d"),V=Y*Math.PI/180,T=w(Y)%180,ab=T>90?(180-T):T,X=ab*Math.PI/180,Z=this.originalImage,aa=Z.naturalWidth,ac=Z.naturalHeight,S=w(aa*b(X)+ac*i(X)),ad=w(aa*i(X)+ac*b(X));W.width=S;W.height=ad;U.save();U.translate(S/2,ad/2);U.rotate(V);U.drawImage(this.$original[0],-aa/2,-ac/2,aa,ac);U.restore();return W.toDataURL()},zoom:function(W){var V=this.image,U,S,T;W=M(W);if(!this.built||!W||this.disabled||!this.defaults.zoomable){return}U=V.width*(1+W);S=V.height*(1+W);T=U/V._width;if(T>10){return}if(T<1){U=V._width;S=V._height}if(T<=1){this.setDragMode("crop")}else{this.setDragMode("move")}V.oldWidth=V.width;V.oldHeight=V.height;V.width=U;V.height=S;V.ratio=V.width/V.naturalWidth;this.renderImage("zoom")},dblclick:function(){if(this.disabled){return}if(this.$canvas.hasClass(G)){this.setDragMode("move")}else{this.setDragMode("crop")}},wheel:function(S){var T=S.originalEvent,U=1;if(this.disabled){return}S.preventDefault();if(T.deltaY){U=T.deltaY>0?1:-1}else{if(T.wheelDelta){U=-T.wheelDelta/120}else{if(T.detail){U=T.detail>0?1:-1}}}this.zoom(U*0.1)},dragstart:function(U){var W=U.originalEvent.touches,V=U,X,T,S;if(this.disabled){return}if(W){S=W.length;if(S>1){if(this.defaults.zoomable&&S===2){V=W[1];this.startX2=V.pageX;this.startY2=V.pageY;X="zoom"}else{return}}V=W[0]}X=X||B(V.target).data(j);if(R.test(X)){U.preventDefault();T=B.Event(z);this.$element.trigger(T);if(T.isDefaultPrevented()){return}this.directive=X;this.cropping=L;this.startX=V.pageX;this.startY=V.pageY;if(X==="crop"){this.cropping=v;this.$canvas.addClass(O)}}},dragmove:function(T){var W=T.originalEvent.touches,V=T,U,S;if(this.disabled){return}if(W){S=W.length;if(S>1){if(this.defaults.zoomable&&S===2){V=W[1];this.endX2=V.pageX;this.endY2=V.pageY}else{return}}V=W[0]}if(this.directive){T.preventDefault();U=B.Event(y);this.$element.trigger(U);if(U.isDefaultPrevented()){return}this.endX=V.pageX;this.endY=V.pageY;this.dragging()}},dragend:function(S){var T;if(this.disabled){return}if(this.directive){S.preventDefault();T=B.Event(h);this.$element.trigger(T);if(T.isDefaultPrevented()){return}if(this.cropping){this.cropping=L;this.$canvas.toggleClass(O,this.cropped&&this.defaults.modal)}this.directive=""}},dragging:function(){var ac=this.directive,Y=this.image,T=this.cropper,ae=T.width,af=T.height,V=this.dragger,W=V.width,ah=V.height,X=V.left,ab=V.top,ad=X+W,S=ab+ah,U=v,ag=this.defaults.aspectRatio,aa={x:this.endX-this.startX,y:this.endY-this.startY},Z;if(ag){aa.X=aa.y*ag;aa.Y=aa.x/ag}switch(ac){case"all":X+=aa.x;ab+=aa.y;break;case"e":if(aa.x>=0&&(ad>=ae||ag&&(ab<=0||S>=af))){U=L;break}W+=aa.x;if(ag){ah=W/ag;ab-=aa.Y/2}if(W<0){ac="w";W=0}break;case"n":if(aa.y<=0&&(ab<=0||ag&&(X<=0||ad>=ae))){U=L;break}ah-=aa.y;ab+=aa.y;if(ag){W=ah*ag;X+=aa.X/2}if(ah<0){ac="s";ah=0}break;case"w":if(aa.x<=0&&(X<=0||ag&&(ab<=0||S>=af))){U=L;break}W-=aa.x;X+=aa.x;if(ag){ah=W/ag;ab+=aa.Y/2}if(W<0){ac="e";W=0}break;case"s":if(aa.y>=0&&(S>=af||ag&&(X<=0||ad>=ae))){U=L;break}ah+=aa.y;if(ag){W=ah*ag;X-=aa.X/2}if(ah<0){ac="n";ah=0}break;case"ne":if(ag){if(aa.y<=0&&(ab<=0||ad>=ae)){U=L;break}ah-=aa.y;ab+=aa.y;W=ah*ag}else{if(aa.x>=0){if(ad<ae){W+=aa.x}else{if(aa.y<=0&&ab<=0){U=L}}}else{W+=aa.x}if(aa.y<=0){if(ab>0){ah-=aa.y;ab+=aa.y}}else{ah-=aa.y;ab+=aa.y}}if(W<0&&ah<0){ac="sw";ah=0;W=0}else{if(W<0){ac="nw";W=0}else{if(ah<0){ac="se";ah=0}}}break;case"nw":if(ag){if(aa.y<=0&&(ab<=0||X<=0)){U=L;break}ah-=aa.y;ab+=aa.y;W=ah*ag;X+=aa.X}else{if(aa.x<=0){if(X>0){W-=aa.x;X+=aa.x}else{if(aa.y<=0&&ab<=0){U=L}}}else{W-=aa.x;X+=aa.x}if(aa.y<=0){if(ab>0){ah-=aa.y;ab+=aa.y}}else{ah-=aa.y;ab+=aa.y}}if(W<0&&ah<0){ac="se";ah=0;W=0}else{if(W<0){ac="ne";W=0}else{if(ah<0){ac="sw";ah=0}}}break;case"sw":if(ag){if(aa.x<=0&&(X<=0||S>=af)){U=L;break}W-=aa.x;X+=aa.x;ah=W/ag}else{if(aa.x<=0){if(X>0){W-=aa.x;X+=aa.x}else{if(aa.y>=0&&S>=af){U=L}}}else{W-=aa.x;X+=aa.x}if(aa.y>=0){if(S<af){ah+=aa.y}}else{ah+=aa.y}}if(W<0&&ah<0){ac="ne";ah=0;W=0}else{if(W<0){ac="se";W=0}else{if(ah<0){ac="nw";ah=0}}}break;case"se":if(ag){if(aa.x>=0&&(ad>=ae||S>=af)){U=L;break}W+=aa.x;ah=W/ag}else{if(aa.x>=0){if(ad<ae){W+=aa.x}else{if(aa.y>=0&&S>=af){U=L}}}else{W+=aa.x}if(aa.y>=0){if(S<af){ah+=aa.y}}else{ah+=aa.y}}if(W<0&&ah<0){ac="nw";ah=0;W=0}else{if(W<0){ac="sw";W=0}else{if(ah<0){ac="ne";ah=0}}}break;case"move":Y.left+=aa.x;Y.top+=aa.y;this.renderImage("move");U=L;break;case"zoom":this.zoom(function(ai,an,ak,am,aj,al){return(D(aj*aj+al*al)-D(ak*ak+am*am))/D(ai*ai+an*an)}(Y.width,Y.height,w(this.startX-this.startX2),w(this.startY-this.startY2),w(this.endX-this.endX2),w(this.endY-this.endY2)));this.endX2=this.startX2;this.endY2=this.startY2;U=L;break;case"crop":if(aa.x&&aa.y){Z=this.$cropper.offset();X=this.startX-Z.left;ab=this.startY-Z.top;W=V.minWidth;ah=V.minHeight;if(aa.x>0){if(aa.y>0){ac="se"}else{ac="ne";ab-=ah}}else{if(aa.y>0){ac="sw";X-=W}else{ac="nw";X-=W;ab-=ah}}if(!this.cropped){this.cropped=v;this.$dragger.removeClass(F)}}break}if(U){V.width=W;V.height=ah;V.left=X;V.top=ab;this.directive=ac;this.renderDragger()}this.startX=this.endX;this.startY=this.endY}};t.TEMPLATE=(function(S,T){T=T.split(",");return S.replace(/\d+/g,function(U){return T[U]})})('<0 6="5-container"><0 6="5-canvas"></0><0 6="5-dragger"><1 6="5-viewer"></1><1 6="5-8 8-h"></1><1 6="5-8 8-v"></1><1 6="5-face" 3-2="all"></1><1 6="5-7 7-e" 3-2="e"></1><1 6="5-7 7-n" 3-2="n"></1><1 6="5-7 7-w" 3-2="w"></1><1 6="5-7 7-s" 3-2="s"></1><1 6="5-4 4-e" 3-2="e"></1><1 6="5-4 4-n" 3-2="n"></1><1 6="5-4 4-w" 3-2="w"></1><1 6="5-4 4-s" 3-2="s"></1><1 6="5-4 4-ne" 3-2="ne"></1><1 6="5-4 4-nw" 3-2="nw"></1><1 6="5-4 4-sw" 3-2="sw"></1><1 6="5-4 4-se" 3-2="se"></1></0></0>',"div,span,directive,data,point,cropper,class,line,dashed");t.DEFAULTS={aspectRatio:"auto",autoCropArea:0.8,data:{},done:B.noop,preview:"",multiple:L,autoCrop:v,dragCrop:v,dashed:v,modal:v,movable:v,resizable:v,zoomable:v,rotatable:v,checkImageOrigin:v,minWidth:0,minHeight:0,maxWidth:k,maxHeight:k,minContainerWidth:300,minContainerHeight:150,build:x,built:x,dragstart:x,dragmove:x,dragend:x};t.setDefaults=function(S){B.extend(t.DEFAULTS,S)};t.other=B.fn.cropper;B.fn.cropper=function(U){var T=s(arguments,1),S;this.each(function(){var X=B(this),W=X.data("cropper"),V;if(!W){X.data("cropper",(W=new t(this,U)))}if(typeof U==="string"&&B.isFunction((V=W[U]))){S=V.apply(W,T)}});return(typeof S!==u?S:this)};B.fn.cropper.Constructor=t;B.fn.cropper.setDefaults=t.setDefaults;B.fn.cropper.noConflict=function(){B.fn.cropper=t.other;return this}});